﻿//Page variables
Xrm = parent.Xrm;
CrmRestKit = parent.CrmRestKit;
var counter = 0;
var newVODId = null;
var startTime = new Date(); //Get the current date/time

function requestVOD() {
    //Disable the buttons
    $("#RequestButton").attr('disabled', true);
    $("#PatientEmailAddressTextBox").attr('disabled', true);

    //Validate the Patient E-mail field exists
    var patientEmail = $("#PatientEmailAddressTextBox").val();
    var checkValidEmail = ValidateEmail(patientEmail);
    if (checkValidEmail == false)
    {
        hideAll();
        $("#validationErrors").text("");
        $("#validationErrors").append("Invalid email format detected for: ' " + patientEmail + " '.  Please correct the email and request the On Demand VMR again.");
        $("#msgBoxFailedValidation").show();
        $("#RequestButton").attr('disabled', false);
        $("#PatientEmailAddressTextBox").attr('disabled', false);
        return;
    }

    //Get the current user
    var currentUserId = Xrm.Page.context.getUserId();
    currentUserId = currentUserId.replace("{", "");
    currentUserId = currentUserId.replace("}", "");

    //Reset Counter
    counter = 0;

    //Date
    startTime = new Date();

    //Create a cvt_VOD record
    var newVOD = {
        'cvt_name': patientEmail,
        'cvt_provider': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: currentUserId, LogicalName: "systemuser" },
        'cvt_patientemail': patientEmail
    };

    var createdVOD = CrmRestKit.Create('cvt_vod', newVOD)
                                       .fail(function () {
                                           alert("create failed");
                                       }).done(function () {
                                           showExecutingSearch();
                                           newVODId = JSON.parse(createdVOD.responseText).d.cvt_vodId
                                           waitForUpdate();
                                       });

}

function manualCheckForVMR() {
    hideAll();
    $("#msgBoxWorking").show();
    $("#msgBoxWorking").focus();
    counter = 9;

    setTimeout(function () { waitForUpdate(); }, 500);
    
}

function waitForUpdate() {

    var calls = CrmRestKit.Retrieve("cvt_vod", newVODId, ['statuscode'], false);
    calls.fail(
            function (error) {
                return;
            })
    calls.done(function (data) {
        hideAll();

        //Requested
        switch (data.d.statuscode.Value) {
            case 1: //Requested
                showExecutingSearch();
                counter++;
                if (counter < 10) {
                    setTimeout(function () { waitForUpdate(); }, 3000);
                }
                else {
                    //Show error message
                    $("#noResultText").text("");
                    $("#noResultText").append("The VMR is still being generated.");
                    hideAll();
                    $("#msgBoxNoResult").show();
                    return;
                }  
                break;
            case 917290000: //Success
                $("#msgBoxSuccess").show();
                break;
            case 917290001: //Failure
                $("#errorText").text("");
                //Find the Integration Result
                var filter = "cvt_vod/Id eq (Guid'" + newVODId + "')";
                calls = CrmRestKit.ByQuery("mcs_integrationresult", ['mcs_error'], filter, false);
                calls.fail(
                        function (error) {
                            return;
                        })
                calls.done(function (data) {
                    if (data && data.d.results && data.d.results.length > 0) {
                        var integrationError = data.d.results[0].mcs_error;
                        $("#errorText").append(" Error: " + integrationError);
                        $("#errorText").append("<br/><br/>Please try again.");
                        $("#RequestButton").attr('disabled', false);
                        $("#PatientEmailAddressTextBox").attr('disabled', false);
                    }
                });
                $("#msgBoxFailedIntegration").show();
                break;
        }
    });
}

//Show Executing Search
function showExecutingSearch() {
    hideAll();
    $("#RequestButton").attr('disabled', true);
    $("#PatientEmailAddressTextBox").attr('disabled', true);

    $("#msgBoxWorking").show();
    $("#msgBoxWorking").focus();
}

//Hide all Message Divs
function hideAll() {
    $("#msgBoxWorking").hide();
    $("#msgBoxFailedIntegration").hide();
    $("#msgBoxFailedValidation").hide();
    $("#msgBoxNoResult").hide();
    $("#msgBoxSuccess").hide();
}

function ValidateEmail(mail) {
    if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail)) {
        return true;
    }
    return false;
}